/*
 * Decompiled with CFR 0.152.
 */
package layout;

import data.Branch;
import data.Leaf;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JPanel;
import main.Main;

public class BranchPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ArrayList<Branch> branches = new ArrayList();

    public BranchPanel() {
        this.setBackground(Color.black);
        this.setVisible(true);
        this.setLayout(null);
    }

    public void setBranch(ArrayList<Branch> branches) {
        this.branches = branches;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g.setColor(new Color(200, 200, 200));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(new Color(100, 70, 30));
        Map<Integer, Leaf> leaves = Main.getTrees().get(Main.editTreeId).getLeaves();
        Point headPoint = new Point();
        Point tailPoint = new Point();
        int i = 0;
        while (i < this.branches.size()) {
            int headId = this.branches.get(i).getHeadId();
            int tailId = this.branches.get(i).getTailId();
            headPoint = leaves.get(headId).getPoint();
            Leaf leaf = leaves.get(tailId);
            tailPoint = leaf != null ? leaf.getPoint() : Main.getTrees().get((Object)Integer.valueOf((int)Main.editTreeId)).rootPoint;
            g2d.setStroke(new BasicStroke((float)leaves.get(headId).getProb() / 10.0f + 0.1f));
            g2d.drawLine(headPoint.x, headPoint.y, tailPoint.x, tailPoint.y);
            g2d.setStroke(new BasicStroke());
            ++i;
        }
    }
}

