/*
 * Decompiled with CFR 0.152.
 */
package layout;

import data.Branch;
import data.Chara;
import data.Leaf;
import data.Tree;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import layout.BranchPanel;
import layout.FormSet;
import layout.IntegerInputVerifier;
import layout.LeafLayout;
import layout.MinutesInputVerifier;
import main.Main;
import method.Method_Event;
import method.Method_Image;
import method.Method_MouseEvent;

public class Layout {
    public static JTextField textField = new JTextField(48);
    public static JComboBox<String> form_chara;
    public static JComboBox<String> form_icon;
    public static JTextArea form_serif;
    public static JComboBox<String> form_parent;
    public static JTextField form_prob;
    public static JTextField form_minutes;
    public static JLabel lbl_icon;
    public static JFrame subWindow;

    public static void makeLayout_initial(String message) {
        JPanel side = Main.getPanel_side();
        JPanel main = Main.getPanel_main();
        JPanel msg = Main.getPanel_msg();
        side.removeAll();
        side.setBackground(Color.DARK_GRAY);
        main.removeAll();
        main.setBackground(new Color(200, 220, 180));
        msg.removeAll();
        msg.setBackground(Color.BLUE);
        msg.setVisible(false);
        JButton btn_charaMake = new JButton("\u30ad\u30e3\u30e9\u4f5c\u6210");
        btn_charaMake.setActionCommand("layout_charaMake");
        JButton btn_charaEdit = new JButton("\u30ad\u30e3\u30e9\u7de8\u96c6");
        btn_charaEdit.setActionCommand("layout_charaList");
        JButton btn_treeMake = new JButton("\u30c4\u30ea\u30fc\u4f5c\u6210");
        btn_treeMake.setActionCommand("layout_treeList");
        btn_charaMake.addActionListener(new Method_Event());
        btn_charaEdit.addActionListener(new Method_Event());
        btn_treeMake.addActionListener(new Method_Event());
        JFrame frame = Main.getFrame();
        side.setLayout(new BoxLayout(side, 1));
        side.add(btn_charaMake);
        side.add(btn_charaEdit);
        side.add(btn_treeMake);
        main.add(new JLabel(message));
        frame.add((Component)side, "West");
        frame.add((Component)main, "Center");
        frame.add((Component)msg, "North");
        frame.validate();
        frame.repaint();
    }

    public static void makeLayout_charaMake(String behave) {
        JPanel panel = Main.getPanel_main();
        panel.setLayout(new FlowLayout(1, 1000, 30));
        panel.removeAll();
        panel.setBackground(new Color(200, 220, 180));
        textField.setText(Main.tmpChara.getName());
        textField.setHorizontalAlignment(0);
        int icon_num = 4;
        JButton[] btn_upload = new JButton[icon_num];
        JLabel[] lbl_icon = new JLabel[icon_num];
        JPanel[] blocks = new JPanel[icon_num];
        int i = 0;
        while (i < icon_num) {
            btn_upload[i] = new JButton("\u753b\u50cf\u767b\u9332");
            btn_upload[i].setActionCommand("act_uploadImage");
            btn_upload[i].addActionListener(new Method_Event(i));
            lbl_icon[i] = new JLabel();
            if (Main.tmpChara.getIconPath(i) == null) {
                lbl_icon[i].setIcon(new ImageIcon(Method_Image.makeImage(100, 100, "aplication_data/no_image.jpg")));
            } else {
                lbl_icon[i].setIcon(new ImageIcon(Method_Image.makeImage(100, 100, Main.tmpChara.getIconPath(i))));
            }
            blocks[i] = new JPanel();
            ++i;
        }
        JButton btn_decide = new JButton(behave);
        btn_decide.setSize(1000, 1000);
        if (behave.equals("\u4f5c\u6210")) {
            btn_decide.setActionCommand("act_addChara");
        } else if (behave.equals("\u5909\u66f4")) {
            btn_decide.setActionCommand("act_renewChara");
        }
        btn_decide.addActionListener(new Method_Event());
        btn_decide.setAlignmentX(0.5f);
        JPanel p0 = new JPanel();
        JPanel p1 = new JPanel();
        p0.add(textField);
        p0.setBorder(new TitledBorder(new EtchedBorder(), "\u540d\u524d"));
        p0.setBackground(new Color(200, 220, 180));
        p1.setBackground(new Color(200, 220, 180));
        p1.setLayout(new FlowLayout(1, 30, 30));
        p1.setBorder(new TitledBorder(new EtchedBorder(), "\u30a2\u30a4\u30b3\u30f3\uff081\u30ad\u30e3\u30e94\u500b\u307e\u3067\uff09"));
        int i2 = 0;
        while (i2 < icon_num) {
            blocks[i2].setLayout(new BorderLayout());
            blocks[i2].add((Component)lbl_icon[i2], "Center");
            blocks[i2].add((Component)btn_upload[i2], "South");
            p1.add(blocks[i2]);
            ++i2;
        }
        panel.add(p0);
        panel.add(p1);
        panel.add(btn_decide);
        panel.validate();
        panel.repaint();
    }

    public static void makeLayout_charaList() {
        JPanel panel = Main.getPanel_main();
        panel.removeAll();
        Map<Integer, Chara> charas = Main.getCharas();
        JPanel[] blocks = new JPanel[charas.size()];
        JLabel[] lbl_names = new JLabel[charas.size()];
        JLabel[] lbl_icons = new JLabel[charas.size()];
        JButton[] btn_edit = new JButton[charas.size()];
        JButton[] btn_delete = new JButton[charas.size()];
        panel.setLayout(new FlowLayout(1, 20, 20));
        int index = 0;
        for (Map.Entry<Integer, Chara> set : charas.entrySet()) {
            lbl_names[index] = new JLabel(set.getValue().getName());
            lbl_names[index].setAlignmentX(0.5f);
            lbl_icons[index] = new JLabel();
            lbl_icons[index].setAlignmentX(0.5f);
            btn_edit[index] = new JButton("\u7de8\u96c6");
            btn_edit[index].setActionCommand("act_charaEdit");
            btn_edit[index].addActionListener(new Method_Event(set.getKey()));
            btn_delete[index] = new JButton("\u524a\u9664");
            btn_delete[index].setActionCommand("act_charaDelete");
            btn_delete[index].addActionListener(new Method_Event(set.getKey()));
            blocks[index] = new JPanel();
            blocks[index].setBackground(new Color(200, 220, 180));
            lbl_icons[index].setIcon(new ImageIcon(Method_Image.makeImage(100, 100, set.getValue().getIconPath(0))));
            blocks[index].setBorder(new BevelBorder(0));
            blocks[index].setLayout(new BoxLayout(blocks[index], 1));
            blocks[index].add(lbl_names[index]);
            blocks[index].add(lbl_icons[index]);
            JPanel south = new JPanel(new FlowLayout(1, 0, 0));
            blocks[index].add(south);
            south.add(btn_edit[index]);
            south.add(btn_delete[index]);
            panel.add(blocks[index]);
            ++index;
        }
        panel.validate();
        panel.repaint();
    }

    public static void makeLayout_treeList() {
        JPanel panel = Main.getPanel_main();
        panel.removeAll();
        panel.setLayout(new GridLayout(4, 6));
        JPanel[] blocks = new JPanel[24];
        JLabel[] lbl_state = new JLabel[24];
        JButton[] btn_edit = new JButton[24];
        Map<Integer, Tree> _trees = Main.getTrees();
        TreeMap<Integer, Tree> trees = new TreeMap<Integer, Tree>(_trees);
        int index = 0;
        for (Map.Entry<Integer, Tree> set : trees.entrySet()) {
            blocks[index] = new JPanel();
            blocks[index].setBorder(new EtchedBorder(1));
            lbl_state[index] = new JLabel();
            btn_edit[index] = new JButton("\u4f5c\u6210\u30fb\u7de8\u96c6");
            btn_edit[index].setActionCommand("layout_treeEdit");
            btn_edit[index].addActionListener(new Method_Event(set.getKey()));
            if (trees.get(index).getLeaves().size() == 0) {
                lbl_state[index].setText(String.valueOf(set.getValue().getHour()) + "\u6642\uff1a\u7a7a");
            } else {
                lbl_state[index].setForeground(Color.blue);
                lbl_state[index].setText(String.valueOf(set.getValue().getHour()) + "\u6642\uff1a\u6e08");
            }
            blocks[index].add((Component)lbl_state[index], "North");
            blocks[index].add((Component)btn_edit[index], "Center");
            panel.add(blocks[index]);
            ++index;
        }
        panel.validate();
        panel.repaint();
    }

    public static void makeLayout_treeEdit(int id) {
        JPanel base = Main.getPanel_main();
        base.removeAll();
        base.setLayout(new BorderLayout());
        Tree tree = Main.getTrees().get(id);
        ArrayList<Branch> branches = tree.getBranches();
        BranchPanel panel = new BranchPanel();
        panel.setBranch(branches);
        base.add(panel);
        JButton btn = new JButton();
        btn.setLayout(new BoxLayout(btn, 1));
        JLabel lbl_root = new JLabel("\u59cb\u70b9");
        lbl_root.setAlignmentX(0.5f);
        btn.add(lbl_root);
        JLabel lbl_hour = new JLabel(String.valueOf(tree.getHour()) + ":00");
        lbl_hour.setAlignmentX(0.5f);
        btn.add(lbl_hour);
        panel.add(btn);
        int rootId = -1;
        btn.addMouseListener(new Method_MouseEvent(btn, rootId, "root"));
        btn.addMouseMotionListener(new Method_MouseEvent(btn, -1, "root"));
        btn.addActionListener(new Method_Event(-1));
        btn.setActionCommand("rootBtn");
        btn.setBounds(tree.rootPoint.x - 25, tree.rootPoint.y - 25, 50, 50);
        btn.setMargin(new Insets(1, 1, 1, 1));
        Map<Integer, Leaf> leaves = tree.getLeaves();
        for (Map.Entry<Integer, Leaf> set : leaves.entrySet()) {
            LeafLayout leafLayout = new LeafLayout(set.getValue());
            panel.add(leafLayout);
            leafLayout.setLocation(set.getValue().getPoint().x - 100, set.getValue().getPoint().y - 40 + 25);
        }
        JPanel menu = Main.getPanel_side();
        menu.removeAll();
        JButton btn_addLeaf = new JButton("\u8449\u3092\u8ffd\u52a0");
        btn_addLeaf.setActionCommand("layout_leafMake");
        JButton btn_editLeaf = new JButton("\u8449\u3092\u7de8\u96c6");
        btn_editLeaf.setActionCommand("leafEdit");
        JButton btn_removeLeaf = new JButton("\u8449\u3092\u524a\u9664");
        btn_removeLeaf.setActionCommand("leafDelete");
        JButton btn_back = new JButton("\u3000\u623b\u308b\u3000");
        btn_back.setActionCommand("layout_back");
        btn_addLeaf.addActionListener(new Method_Event());
        btn_editLeaf.addActionListener(new Method_Event());
        btn_removeLeaf.addActionListener(new Method_Event());
        btn_back.addActionListener(new Method_Event());
        menu.add(btn_addLeaf);
        menu.add(btn_editLeaf);
        menu.add(btn_removeLeaf);
        menu.add(btn_back);
        panel.setLayout(null);
        Main.getFrame().validate();
        Main.getFrame().repaint();
    }

    public static void makeLayout_leafMake(Leaf leaf, int parentId) {
        JButton btn_create;
        JFrame frame = new JFrame();
        frame.setVisible(true);
        frame.setSize(600, 600);
        if (leaf == null) {
            frame.setTitle("\u30ea\u30fc\u30d5\u4f5c\u6210");
        } else {
            frame.setTitle("\u30ea\u30fc\u30d5\u7de8\u96c6");
        }
        lbl_icon = new JLabel();
        Tree tree = Main.getTrees().get(Main.editTreeId);
        Map<Integer, Leaf> leaves = tree.getLeaves();
        form_chara = new JComboBox();
        form_icon = new JComboBox();
        form_chara.addActionListener(new Method_Event());
        form_icon.addActionListener(new Method_Event());
        form_chara.setActionCommand("act_choiseName");
        form_icon.setActionCommand("act_choiseIcon");
        Map<Integer, Chara> charas = Main.getCharas();
        for (Map.Entry<Integer, Chara> entry : charas.entrySet()) {
            form_chara.addItem(entry.getValue().getName());
        }
        form_serif = new JTextArea(3, 50);
        form_parent = new JComboBox();
        form_parent.addItem("\u59cb\u70b9");
        if (leaf != null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            Method_Event.searchId(leaf.getId(), tree, arrayList);
            for (Map.Entry<Integer, Leaf> entry : leaves.entrySet()) {
                boolean child_flag = false;
                int i = 0;
                while (i < arrayList.size()) {
                    if (entry.getKey() == arrayList.get(i)) {
                        child_flag = true;
                        break;
                    }
                    ++i;
                }
                if (child_flag) continue;
                form_parent.addItem(entry.getValue().getSerif());
            }
        } else {
            for (Map.Entry<Integer, Leaf> entry : leaves.entrySet()) {
                form_parent.addItem(entry.getValue().getSerif());
            }
        }
        form_prob = new JTextField("100");
        form_prob.setInputVerifier(new IntegerInputVerifier());
        form_minutes = new JTextField("15");
        form_minutes.setInputVerifier(new MinutesInputVerifier());
        if (leaf != null) {
            String string = charas.get(leaf.getCharaId()).getName();
            form_chara.setSelectedItem(string);
            form_serif.setText(leaf.getSerif());
            form_prob.setText(Integer.toString(leaf.getProb()));
            form_minutes.setText(Integer.toString(leaf.getTime()));
            ArrayList<Branch> arrayList = tree.getBranches();
            int i = 0;
            while (i < arrayList.size()) {
                Leaf lf;
                if (arrayList.get(i).getHeadId() == leaf.getId() && (lf = leaves.get(arrayList.get(i).getTailId())) != null) {
                    form_parent.setSelectedItem(lf.getSerif());
                }
                ++i;
            }
        } else if (parentId != -1) {
            form_parent.setSelectedItem(leaves.get(parentId).getSerif());
        }
        JPanel[] jPanelArray = new JPanel[6];
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        frame.add(jPanel);
        int i = 0;
        while (i < jPanelArray.length) {
            jPanelArray[i] = new JPanel();
            jPanelArray[i].setLayout(new BoxLayout(jPanelArray[i], 0));
            jPanelArray[i].setBackground(Color.orange);
            jPanelArray[i].setVisible(true);
            jPanel.add(jPanelArray[i]);
            ++i;
        }
        jPanelArray[0].add(form_chara);
        jPanelArray[0].setBorder(new TitledBorder("\u30ad\u30e3\u30e9\u540d"));
        jPanelArray[1].add(lbl_icon);
        jPanelArray[1].add(form_icon);
        jPanelArray[1].setBorder(new TitledBorder("\u4f7f\u7528\u30a2\u30a4\u30b3\u30f3"));
        jPanelArray[2].add(form_serif);
        jPanelArray[2].setBorder(new TitledBorder("\u30bb\u30ea\u30d5"));
        jPanelArray[3].add(form_parent);
        jPanelArray[3].setBorder(new TitledBorder("\u8ffd\u52a0\u5834\u6240"));
        jPanelArray[4].add(form_prob);
        jPanelArray[4].setBorder(new TitledBorder("\u6d3e\u751f\u78ba\u7387\uff08%\uff09"));
        jPanelArray[5].add(form_minutes);
        jPanelArray[5].setBorder(new TitledBorder("\u30b3\u30e1\u30f3\u30c8\u6642\u9593\uff08\u5206\uff09"));
        if (leaf == null) {
            btn_create = new JButton("\u8ffd\u52a0");
            btn_create.setActionCommand("act_makeLeaf");
            btn_create.addActionListener(new Method_Event());
        } else {
            btn_create = new JButton("\u5909\u66f4");
            btn_create.setActionCommand("act_editLeaf");
            btn_create.addActionListener(new Method_Event(leaf.getId()));
        }
        jPanel.add(btn_create);
        frame.validate();
        frame.repaint();
        subWindow = frame;
    }

    public static void makeLayout_layoutMake() {
        JPanel panel = Main.getPanel_main();
        panel.removeAll();
        panel.setLayout(new BoxLayout(panel, 1));
        ArrayList<FormSet> forms = new ArrayList<FormSet>();
        FormSet form_width = new FormSet("\u5168\u4f53\u306e\u5e45(px)");
        form_width.setForm(new JTextField(5));
        forms.add(form_width);
        FormSet form_height = new FormSet("\u5168\u4f53\u306e\u9ad8\u3055(px)");
        form_height.setForm(new JTextField(5));
        forms.add(form_height);
        FormSet form_num = new FormSet("\u8449\u306e\u6700\u5927\u8868\u793a\u6570");
        form_num.setForm(new JTextField(3));
        forms.add(form_num);
        FormSet form_iconSize = new FormSet("\u30a2\u30a4\u30b3\u30f3\u306e\u30b5\u30a4\u30ba(px)");
        form_iconSize.setForm(new JTextField(5));
        forms.add(form_iconSize);
        FormSet form_margin = new FormSet("\u30de\u30fc\u30b8\u30f3(px)");
        form_margin.setForm(new JTextField(5));
        forms.add(form_margin);
        int i = 0;
        while (i < forms.size()) {
            panel.add((Component)forms.get(i));
            ++i;
        }
        JButton btn = new JButton("\u9069\u7528");
        btn.setActionCommand("act_decideLayout");
        btn.addActionListener(new Method_Event());
        panel.add(btn);
        panel.validate();
        panel.repaint();
    }

    public static void setMessage(String msg) {
        Main.getPanel_msg().setVisible(true);
        Main.getPanel_msg().removeAll();
        JLabel lbl = new JLabel(msg);
        lbl.setForeground(Color.red);
        Main.getPanel_msg().add(lbl);
    }
}

