/*
 * Decompiled with CFR 0.152.
 */
package layout;

import data.Chara;
import data.Leaf;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import main.Main;
import method.Method_Event;
import method.Method_Image;
import method.Method_MouseEvent;

public class LeafLayout
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int LEAF_WIDTH = 200;
    public static final int LEAF_HEIGHT = 80;
    public static final int LEAF_BTN_HEIGHT = 25;
    JLabel prob = new JLabel();
    JLabel name = new JLabel();
    JLabel minutes = new JLabel();
    JButton icon = new JButton();
    JTextArea serif = new JTextArea();
    Point point = new Point();
    int id = -1;

    public LeafLayout(Leaf leaf) {
        Map<Integer, Chara> charas = Main.getCharas();
        this.prob.setText(String.valueOf(Integer.toString(leaf.getProb())) + "%");
        this.name.setText(charas.get(leaf.getCharaId()).getName());
        this.name.setAlignmentX(0.5f);
        this.minutes.setText(String.valueOf(Main.getTrees().get(Main.editTreeId).getHour()) + "\u6642" + leaf.getTime() + "\u5206");
        this.minutes.setAlignmentX(1.0f);
        String iconPath = Main.getCharas().get(leaf.getCharaId()).getIconPath(leaf.getIconId());
        this.icon.setIcon(new ImageIcon(Method_Image.makeImage(50, 50, iconPath)));
        this.icon.setMargin(new Insets(0, 0, 0, 0));
        this.serif.setText(leaf.getSerif());
        this.serif.setBackground(new Color(200, 250, 180));
        this.serif.setFont(new Font("Dialog", 0, 9));
        this.serif.setEditable(false);
        JScrollPane pane = new JScrollPane(this.serif);
        this.point = leaf.getPoint();
        this.id = leaf.getId();
        this.setLayout(new BorderLayout());
        this.setBounds(0, 0, 200, 80);
        this.setVisible(true);
        JButton north = new JButton();
        this.add((Component)north, "North");
        north.setMargin(new Insets(1, 1, 1, 1));
        JPanel south = new JPanel();
        this.add((Component)south, "Center");
        north.setLayout(new BoxLayout(north, 0));
        north.add((Component)this.prob, "West");
        north.add(Box.createRigidArea(new Dimension(10, 10)));
        north.add((Component)this.name, "Center");
        north.add(Box.createRigidArea(new Dimension(10, 10)));
        north.add((Component)this.minutes, "East");
        south.setLayout(null);
        south.add(this.icon);
        this.icon.setBounds(0, 0, 50, 50);
        south.add(pane);
        pane.setBounds(50, 0, 150, 50);
        north.addMouseListener(new Method_MouseEvent(this, this.id, "leaf"));
        north.addMouseMotionListener(new Method_MouseEvent(this, this.id, "leaf"));
        north.addActionListener(new Method_Event(this.id));
        north.setActionCommand("leafBtn");
    }
}

