/*
 * Decompiled with CFR 0.152.
 */
package method;

import data.Branch;
import data.Chara;
import data.Leaf;
import data.Tree;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import main.Main;

public class Method_Data {
    public static void saveData() {
        try {
            File file = new File("aplication_data\\data.txt");
            PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
            Map<Integer, Chara> charas = Main.getCharas();
            for (Map.Entry<Integer, Chara> set : charas.entrySet()) {
                pw.println("chara{");
                pw.println("id:" + set.getKey());
                pw.println("name:" + set.getValue().getName());
                int j = 0;
                while (j < 4) {
                    String path = set.getValue().getIconPath(j);
                    pw.println("iconPath:" + path);
                    ++j;
                }
                pw.println("}");
            }
            Map<Integer, Tree> trees = Main.getTrees();
            for (Map.Entry<Integer, Tree> tree : trees.entrySet()) {
                pw.println("tree{");
                pw.println("hour:" + tree.getValue().getHour());
                pw.println("rootX:" + tree.getValue().getPoint().x);
                pw.println("rootY:" + tree.getValue().getPoint().y);
                Map<Integer, Leaf> leaves = tree.getValue().getLeaves();
                for (Map.Entry<Integer, Leaf> leaf : leaves.entrySet()) {
                    pw.println("leaf{");
                    pw.println("id:" + leaf.getValue().getId());
                    pw.println("charaId:" + leaf.getValue().getCharaId());
                    pw.println("iconId:" + leaf.getValue().getIconId());
                    pw.println("minutes:" + leaf.getValue().getTime());
                    String serif = leaf.getValue().getSerif();
                    serif = serif.replace("\n", "\\n");
                    pw.println("serif:" + serif);
                    pw.println("pointX:" + leaf.getValue().getPoint().x);
                    pw.println("pointY:" + leaf.getValue().getPoint().y);
                    pw.println("prob:" + leaf.getValue().getProb());
                    pw.println("}");
                }
                ArrayList<Branch> branches = tree.getValue().getBranches();
                int j = 0;
                while (j < branches.size()) {
                    pw.println("branch{");
                    pw.println("headId:" + branches.get(j).getHeadId());
                    pw.println("tailId:" + branches.get(j).getTailId());
                    pw.println("}");
                    ++j;
                }
                pw.println("}");
            }
            pw.println("}end");
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadData(String fileName) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
            block3: while ((line = br.readLine()) != null) {
                if (line.contains("chara{")) {
                    Chara chara = new Chara("no_name");
                    chara.setId(Integer.parseInt(br.readLine().replace("id:", "")));
                    chara.setName(br.readLine().replace("name:", ""));
                    int i = 0;
                    while (!(line = br.readLine()).equals("}")) {
                        chara.setIconPath(i, line.replace("iconPath:", ""));
                        ++i;
                    }
                    Main.getCharas().put(chara.getId(), chara);
                    continue;
                }
                if (!line.contains("tree{")) continue;
                Map<Integer, Tree> trees = Main.getTrees();
                line = br.readLine();
                int hour = Integer.parseInt(line.replace("hour:", ""));
                for (Map.Entry<Integer, Tree> set : trees.entrySet()) {
                    if (hour != set.getValue().getHour()) continue;
                    Tree tree = set.getValue();
                    int rootX = Integer.parseInt(br.readLine().replace("rootX:", ""));
                    int rootY = Integer.parseInt(br.readLine().replace("rootY:", ""));
                    tree.setPoint(new Point(rootX, rootY));
                    while (!(line = br.readLine()).equals("}")) {
                        Map<Integer, Leaf> leaves = tree.getLeaves();
                        ArrayList<Branch> branches = tree.getBranches();
                        if (line.equals("leaf{")) {
                            Leaf leaf = new Leaf(-1);
                            while (!(line = br.readLine()).equals("}")) {
                                if (line.contains("id:")) {
                                    int id = Integer.parseInt(line.replace("id:", ""));
                                    leaf.setId(id);
                                    continue;
                                }
                                if (line.contains("charaId:")) {
                                    leaf.setCharaId(Integer.parseInt(line.replace("charaId:", "")));
                                    continue;
                                }
                                if (line.contains("minutes:")) {
                                    leaf.setMinutes(Integer.parseInt(line.replace("minutes:", "")));
                                    continue;
                                }
                                if (line.contains("iconId:")) {
                                    leaf.setIconId(Integer.parseInt(line.replace("iconId:", "")));
                                    continue;
                                }
                                if (line.contains("serif:")) {
                                    leaf.setSerif(line.replace("serif:", "").replace("\\n", "\n"));
                                    continue;
                                }
                                if (line.contains("pointX:")) {
                                    leaf.getPoint().x = Integer.parseInt(line.replace("pointX:", ""));
                                    continue;
                                }
                                if (line.contains("pointY:")) {
                                    leaf.getPoint().y = Integer.parseInt(line.replace("pointY:", ""));
                                    continue;
                                }
                                if (!line.contains("prob:")) continue;
                                leaf.setProb(Integer.parseInt(line.replace("prob:", "")));
                            }
                            leaves.put(leaf.getId(), leaf);
                            continue;
                        }
                        if (!line.equals("branch{")) continue;
                        int headId = -2;
                        int tailId = -2;
                        while (!(line = br.readLine()).equals("}")) {
                            if (line.contains("headId:")) {
                                headId = Integer.parseInt(line.replace("headId:", ""));
                                continue;
                            }
                            if (!line.contains("tailId:")) continue;
                            tailId = Integer.parseInt(line.replace("tailId:", ""));
                        }
                        Branch branch = new Branch(headId, tailId);
                        branches.add(branch);
                    }
                    continue block3;
                }
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void exportData(String importFile, String exportFile) {
        try {
            Map<Integer, Chara> charas;
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(importFile), "UTF-8"));
            File file = new File(exportFile);
            PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
            block3: while ((line = br.readLine()) != null) {
                pw.println(line);
                if (!line.contains("//autoWriteTree_start")) continue;
                int tree_index = 0;
                Map<Integer, Tree> trees = Main.getTrees();
                charas = Main.getCharas();
                for (Map.Entry<Integer, Tree> entry : trees.entrySet()) {
                    Map<Integer, Leaf> leaves = entry.getValue().getLeaves();
                    ArrayList<Branch> branches = entry.getValue().getBranches();
                    pw.println("leaves = new Array(" + leaves.size() + ");");
                    int leaf_index = 0;
                    for (Map.Entry<Integer, Leaf> leaf : leaves.entrySet()) {
                        int id = leaf.getKey();
                        String name = charas.get(leaf.getValue().getCharaId()).getName();
                        int minutes = leaf.getValue().getTime();
                        String[] array = charas.get(leaf.getValue().getCharaId()).getIconPath(leaf.getValue().getIconId()).split("\\\\");
                        String path = "upload_data/img/" + array[array.length - 1];
                        String serif = leaf.getValue().getSerif().replace("\n", "<br />");
                        int prob = leaf.getValue().getProb();
                        pw.println("leaves[" + leaf_index + "]=new Leaf(" + id + ",\"" + name + "\"," + minutes + ",\"" + path + "\",\"" + serif + "\"," + prob + ");");
                        ++leaf_index;
                    }
                    pw.println("branches = new Array(" + branches.size() + ");");
                    int j = 0;
                    while (j < branches.size()) {
                        int headId = branches.get(j).getHeadId();
                        int tailId = branches.get(j).getTailId();
                        pw.println("branches[" + j + "]=new Branch(" + headId + "," + tailId + ");");
                        ++j;
                    }
                    int hour = entry.getValue().getHour();
                    pw.println("trees[" + tree_index + "]=new Tree(" + hour + ", leaves, branches);");
                    ++tree_index;
                }
                pw.println("//autoWriteTree_end");
                while ((line = br.readLine()) != null) {
                    if (line.contains("//autoWriteTree_end")) continue block3;
                }
            }
            br.close();
            pw.close();
            int ans = JOptionPane.showConfirmDialog(Main.getFrame().getContentPane(), "\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u7528\u306e\u30a4\u30e1\u30fc\u30b8\u30d5\u30a9\u30eb\u30c0\u3092\u521d\u671f\u5316\u3057\u3066\u3001\u5fc5\u8981\u306a\u753b\u50cf\u3092\u30b3\u30d4\u30fc\u3057\u307e\u3059\u304b\uff1f\n\uff08\u3044\u3044\u3048\u306e\u5834\u5408\u306f\u81ea\u5206\u3067upload_data/img/ \u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u7de8\u96c6\u3057\u3066\u304f\u3060\u3055\u3044\uff09", "\u78ba\u8a8d\u30c0\u30a4\u30a2\u30ed\u30b0", 0);
            if (ans == 0) {
                Method_Data.deleteFile(new File("upload_data/img"));
                File img_dir = new File("upload_data/img");
                img_dir.mkdir();
                charas = Main.getCharas();
                for (Map.Entry<Integer, Object> entry : charas.entrySet()) {
                    int j = 0;
                    while (j < 4) {
                        String path = ((Chara)entry.getValue()).getIconPath(j);
                        String[] array = path.split("\\\\");
                        String name = array[array.length - 1];
                        File img_file = new File(path);
                        if (img_file.isFile()) {
                            String format = name.split("\\.")[1];
                            BufferedImage img = ImageIO.read(img_file);
                            ImageIO.write((RenderedImage)img, format, new File("upload_data/img/" + name));
                        }
                        ++j;
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean deleteFile(File dirOrFile) {
        if (dirOrFile.isDirectory()) {
            String[] children = dirOrFile.list();
            int i = 0;
            while (i < children.length) {
                boolean success = Method_Data.deleteFile(new File(dirOrFile, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dirOrFile.delete();
    }
}

