﻿// レイアウトに関するデータ
//autoWriteCss_start
//autoWriteCss_end

//葉を一枚おく
function put_leaf(leaf){
	document.write("<div style=\"width:"+webot_width+";\">");
	document.write("<img src=\"" + leaf.iconPath + "\" width="+icon_size+" height="+icon_size+"></img>");
	document.write("<div style=\"float:right;\">");
	document.write("<p style=\"margin:"+margin+";\">"+leaf.month+"/"+leaf.date+"/"+leaf.hour+":"+leaf.minutes+"</p>");
	document.write("<p style=\"margin:"+margin+";\">"+leaf.name+"</p>");
	document.write("</div>");
	document.write("<p style=\"clear:both; margin:"+margin+"\">"+leaf.serif+"</p>");
	document.write("</div>");
}

// 呼び出し元
function put_webot(){
	// 全てのツリーデータの配列を作成
	var trees = make_treesData();
	// ツリーから必要なリーフだけをとってくる
	var use_leaves=get_useLeaves(trees);
	// 渡したリーフを実際に配置する
	for(var i=0; i<max_leaf_num; i++){
		put_leaf(use_leaves[i]);
	}
}

// ツリーから適切な葉を集めて返す
function get_useLeaves(trees){
	var leaves = new Array();	// 完成品
	var month	= new Date().getMonth();
	var date	= new Date().getDate();
	var hour	= new Date().getHours();
	var minutes	= new Date().getMinutes();
	var tmp_leaves;		// 派生先の葉を一時的に保存
	var part_leaves;	// 派生順に並べた葉を一時的に保存
	var random;		// 日と時と分に依存する乱数を保存
	var tailId;		// 派生先の葉のID、或いはルートID
	var yesterday = new Date();	// 日付変更
	var future_flag = true;	// 未来の葉を選択する可能性
	// 葉が揃うまでツリーから葉を取得し続ける
	while(leaves.length < max_leaf_num){
		tailId = -1;	// -1はルートのID
		part_leaves=new Array();
		random = random_depend(month+date+hour);
		// ルートから末端か、現在までの葉を取得する
		while(true){
			tmp_leaves = new Array();

			// tailIdから葉を何枚か検索し、候補に入れる
			for(var i=0; i<trees[hour].branches.length; i++){
				if(trees[hour].branches[i].tailId == tailId){
					// 未来の葉でなければ、候補に追加する
					if(trees[hour].getLeaf(trees[hour].branches[i].headId).minutes <= minutes || !future_flag){
						tmp_leaves.push(trees[hour].copyLeaf(trees[hour].branches[i].headId));
					}
				}
			}

			// 葉の候補がなければ、1時間前のツリーでやり直し
			if(tmp_leaves.length==0){
				hour--;
				future_flag=false;
				// 日付変更
				if(hour < 0){
					hour = 23;
					yesterday.setDate(yesterday.getDate()-1);
					month = yesterday.getMonth();
					date = yesterday.getDate();
				}
				// 今まで蓄えた葉を整頓して追加
				if(part_leaves.length>0){
					part_leaves.reverse();
					leaves = leaves.concat(part_leaves);	
				}
				break;
			}
			// 葉の候補から確率を取得
			var probs = new Array();	//確率のリスト…20,10,30ならば20,30,60になる
			probs.push(0);
			for(var i=0; i<tmp_leaves.length; i++){
				probs.push(tmp_leaves[i].prob + probs[i]);
			}
			// 確率から葉を選択…取得しない場合もある
			for(var i=0; i<tmp_leaves.length; i++){
				if(probs[i]<=random && random<=probs[i+1]){
					tailId = trees[hour].getBranch(tmp_leaves[i].id).tailId;
					tmp_leaves[i].hour=hour;
					tmp_leaves[i].month=month+1;
					tmp_leaves[i].date=date;
					part_leaves.push(tmp_leaves[i]);
					break;
				}
			}
			// 候補があったが、何処にも派生できなかった…ここクローン
			if(tmp_leaves.length==0){
				hour--;
				future_flag=false;
				// 日付変更
				if(hour < 0){
					hour = 23;

					yesterday.setDate(yesterday.getDate()-1);
					month = yesterday.getMonth();
					date = yesterday.getDate();
				}
				// 今まで蓄えた葉を整頓して追加
				part_leaves.reverse();
				leaves = leaves.concat(part_leaves);		
				break;
			}
		}
	}
	// 終わり
	return leaves;
}
// 入力値に依存した乱数を0～100で返す…しかしただの三角関数…中央付近が粗になりそうだから改善しろ
function random_depend(depend){
	return (1+Math.sin(depend))*50;
}
// ツリーのデータベースを作って渡す…ここが人によって変わる
function make_treesData(){
	var trees = new Array(24);
	for(var i=0; i<trees.length; i++){
		trees[i]=new Tree(i, new Array(), new Array());
	}
	var leaves;
	var branches;
	var iconPath="upload_data/img/no_image.jpg";
	//autoWriteTree_start
	//autoWriteTree_end
	return trees;
}
// ツリーのクラス
var Tree=function(hour, leaves, branches){
	this.hour = hour;	// hourをIDとして利用
	this.leaves = leaves;
	this.branches = branches;
	this.getLeaf = function(id){
		for(var i=0; i<leaves.length; i++){
			if(leaves[i].id==id){
				return leaves[i];
			}
		}
		alert("error:the leaf is not found in getLeaf of this Tree");
	};
	this.copyLeaf = function(id){
		for(var i=0; i<leaves.length; i++){
			if(leaves[i].id==id){
				leaf = new Leaf(leaves[i].id,leaves[i].name,leaves[i].minutes,leaves[i].iconPath,leaves[i].serif,leaves[i].prob);
				return leaf;
			}
		}
		alert("error:the leaf is not found in getLeaf of this Tree");
	};
	this.getBranch = function(id){
		for(var i=0; i<branches.length; i++){
			if(branches[i].tailId == id){
				return branches[i];
			}
		}
		return false;
	}
}
// リーフのクラス
var Leaf=function(id, name, minutes, iconPath, serif, prob){
	this.id=id;
	this.name=name;
	this.minutes=minutes;
	this.iconPath=iconPath;
	this.serif=serif;
	this.prob=prob;
	this.date=0;
	this.month=0;
	this.hour=0;
}
// ブランチのクラス
var Branch=function(headId, tailId){
	this.headId = headId;
	this.tailId = tailId;
}

// end

