﻿// リーフのレイアウト配列・・・<p></p>とか<div class="">とか
var template=new Array();
var leaves;

// 適当な葉をそろえる
function make_leaves(leaf_num){
	var trees=make_trees();
	leaves = get_needLeaves(trees, leaf_num);
}

// リーフのHTMLテンプレートを記述していく
function push(line){
	template.push(line);
}

// テンプレのアイコン・日付・名前・セリフを書き換えて、葉の枚数分吐き出す
function put_leaves(){
	var line;
	for(var i=0; i<leaves.length; i++){
		// 日付を調整
		if(leaves[i].month<10){leaves[i].month="0"+leaves[i].month;}
		if(leaves[i].date<10){leaves[i].date="0"+leaves[i].date;}
		if(leaves[i].hour<10){leaves[i].hour="0"+leaves[i].hour;}
		if(leaves[i].minutes<10){leaves[i].minutes="0"+leaves[i].minutes;}
		
		for(var j=0; j<template.length; j++){
			line = template[j];
			line = line.replace("*IMAGE",leaves[i].iconPath);
			line = line.replace("*DATE",leaves[i].month+"/"+leaves[i].date+"/"+leaves[i].hour+":"+leaves[i].minutes);
			line = line.replace("*NAME",leaves[i].name);
			line = line.replace("*SERIF",leaves[i].serif);
			document.write(line);
		}
	}
}

//============================================================ 葉の検索アルゴリズム
// ツリーから適切な葉を集めて返す
function get_needLeaves(trees, leaf_num){
	var leaves	= new Array();	// 完成品
	var month	= new Date().getMonth();
	var date	= new Date().getDate();
	var hour	= new Date().getHours();
	var minutes	= new Date().getMinutes();
	var tmp_leaves;		// 派生先の葉を一時的に保存
	var part_leaves;	// 派生順に並べた葉を一時的に保存
	var random;		// 日と時と分に依存する乱数を保存
	var tailId;		// 派生先の葉のID、或いはルートID
	var yesterday = new Date();	// 日付変更
	var future_flag = true;	// 未来の葉を選択する可能性
	
	// 葉が揃うまでツリーから葉を取得し続ける
	while(leaves.length < leaf_num){
		tailId = -1;	// -1はルートのID
		part_leaves=new Array();
		random = myRandom((month+1)*(date+1)*(date+2)*(hour+1));
		// ルートから末端か、現在までの葉を取得する
		while(true){
			tmp_leaves = new Array();

			// tailIdから葉を何枚か検索し、候補に入れる
			for(var i=0; i<trees[hour].branches.length; i++){
				if(trees[hour].branches[i].tailId == tailId){
					// 未来の葉でなければ、候補に追加する
					if(trees[hour].getLeaf(trees[hour].branches[i].headId).minutes <= minutes || !future_flag){
						tmp_leaves.push(trees[hour].copyLeaf(trees[hour].branches[i].headId));
					}
				}
			}

			// 葉の候補がなければ、1時間前のツリーでやり直し
			if(tmp_leaves.length==0){
				hour--;
				future_flag=false;
				// 日付変更
				if(hour < 0){
					hour = 23;
					yesterday.setDate(yesterday.getDate()-1);
					month = yesterday.getMonth();
					date = yesterday.getDate();
				}
				// 今まで蓄えた葉を整頓して追加
				if(part_leaves.length>0){
					part_leaves.reverse();
					leaves = leaves.concat(part_leaves);	
				}
				break;
			}
			// 葉の候補から確率を取得
			var probs = new Array();	//確率のリスト…20,10,30ならば20,30,60になる
			probs.push(0);
			for(var i=0; i<tmp_leaves.length; i++){
				probs.push(tmp_leaves[i].prob + probs[i]);
			}
			// 確率から葉を選択…取得しない場合もある
			var next_flag=false;
			for(var i=0; i<tmp_leaves.length; i++){
				if(probs[i]<=random && random<=probs[i+1]){
					// 候補の中から選ばれた葉を、葉のリストに登録
					tailId = trees[hour].getBranch(tmp_leaves[i].id).tailId;
					tmp_leaves[i].hour=hour;
					tmp_leaves[i].month=month+1;
					tmp_leaves[i].date=date;
					part_leaves.push(tmp_leaves[i]);
					
					// 葉が見つかったので、他の葉を探すために、このツリーをもう一周する準備
					next_flag = true;
					var seed=(month+1)*9+(date+2)*5+(hour+3)*2+(tmp_leaves[i].serif.length+4)*3+(tmp_leaves[i].minutes+4)*8;
					random = myRandom(seed);
					break;
				}
			}
			// 候補があったが、何処にも派生できなかったら、ブレイクして一時間前のツリーを探索
			if(!next_flag){
				hour--;
				future_flag=false;
				// 日付変更
				if(hour < 0){
					hour = 23;
					yesterday.setDate(yesterday.getDate()-1);
					month = yesterday.getMonth();
					date = yesterday.getDate();
				}
				// 今まで蓄えた葉を整頓して追加
				part_leaves.reverse();
				leaves = leaves.concat(part_leaves);		
				break;
			}
		}
	}
	// 終わり
	return leaves;
}
//============================================================ 乱数
// 入力値に依存した乱数を0～100で返す…しかしただの三角関数…中央付近が粗になりそうだから改善しろ
//function random_depend(depend){
//	return (1+Math.sin(depend))*50;
//}
function myRandom(seed){
	// seedを素材とした、乱数を作る
	// 混合合同法というシロモノ。　aは５の奇数乗か素数、Lは10の乗数、bは知らん
	var a=71, b=29 ,L=100;
	rnd = (a*seed + b) % L;
	return rnd;
}

//============================================================
// ツリーのデータベースを作って渡す…ここが人によって変わる
function make_trees(){
	var trees = new Array(24);
	for(var i=0; i<trees.length; i++){
		trees[i]=new Tree(i, new Array(), new Array());
	}
	var leaves;
	var branches;
	//autoWriteTree_start
	//autoWriteTree_end
	return trees;
}
//============================================================
// ツリーのクラス
var Tree=function(hour, leaves, branches){
	this.hour = hour;	// hourをIDとして利用
	this.leaves = leaves;
	this.branches = branches;
	this.getLeaf = function(id){
		for(var i=0; i<leaves.length; i++){
			if(leaves[i].id==id){
				return leaves[i];
			}
		}
		alert("error:the leaf is not found in getLeaf of this Tree");
	};
	this.copyLeaf = function(id){
		for(var i=0; i<leaves.length; i++){
			if(leaves[i].id==id){
				leaf = new Leaf(leaves[i].id,leaves[i].name,leaves[i].minutes,leaves[i].iconPath,leaves[i].serif,leaves[i].prob);
				return leaf;
			}
		}
		alert("error:the leaf is not found in getLeaf of this Tree");
	};
	this.getBranch = function(id){
		for(var i=0; i<branches.length; i++){
			if(branches[i].tailId == id){
				return branches[i];
			}
		}
		return false;
	}
}
//============================================================
// リーフのクラス
var Leaf=function(id, name, minutes, iconPath, serif, prob){
	this.id=id;
	this.name=name;
	this.minutes=minutes;
	this.iconPath=iconPath;
	this.serif=serif;
	this.prob=prob;
	this.date=0;
	this.month=0;
	this.hour=0;
}
//============================================================
// ブランチのクラス
var Branch=function(headId, tailId){
	this.headId = headId;
	this.tailId = tailId;
}
//end
//============================================================

